/*
  KPCI-488 example: use of SEND & ENTER to communicate
  with an instrument (Keithley 2000 meter)
*/

#include <formatio.h> 
#include <cvirte.h>		
#include <userint.h>
#include <ansi_c.h>
#include <ieee_32.h> 
#include "2000b.h"  

static int panelHandle; 

int status,l;
int val;

char Data[80];
char Stat[20];
char Leng[20];
static char CommandStr[20];
 

static int panelHandle;

int __stdcall WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
                       LPSTR lpszCmdLine, int nCmdShow)
{
	if (InitCVIRTE (hInstance, 0, 0) == 0)
		return -1;	/* out of memory */
	if ((panelHandle = LoadPanel (0, "2000b.uir", PANEL)) < 0)
		return -1;
	DisplayPanel (panelHandle);
	RunUserInterface ();
	DiscardPanel (panelHandle);
	return 0;
}

int CVICALLBACK Send (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	switch (event)
		{
		case EVENT_COMMIT:
		
			ResetTextBox (panel, PANEL_TEXTBOX,"");
			ResetTextBox (panel, PANEL_TEXTBOX_4,"");    
			ResetTextBox (panel, PANEL_TEXTBOX_5,""); 
		
			/*send the command from Enter Command text box*/  
	
			GetCtrlVal (panel,PANEL_TEXTBOX_2, CommandStr);	
			GetCtrlVal (panel,PANEL_NUMERIC, &val);
	
   			initialize (21,0);                /* make PC a controller at address 21 */
   			send (val,CommandStr,&status);     /* device command to set mode */
 
   			Fmt(Stat, "%s<%d", status); 
    		Fmt(Leng, "%s<%d", l);  
    
    		/*display to value to panel*/

			SetCtrlVal (panel, PANEL_TEXTBOX_5, Stat);  

			break;
		}
	return 0;
}

int CVICALLBACK Enter (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	switch (event)
		{
		case EVENT_COMMIT:
		
			/*clears text boxes*/	
		
			ResetTextBox (panel, PANEL_TEXTBOX,"");
			ResetTextBox (panel, PANEL_TEXTBOX_4,"");    
			ResetTextBox (panel, PANEL_TEXTBOX_5,""); 

   			initialize (21,0);                		/* make PC a controller at address 21 */
 
   			enter (Data,80,&l,val,&status);    		/* read a voltage */
   	
    		Fmt(Stat, "%s<%d", status); 
    		Fmt(Leng, "%s<%d", l);  
    
    		/*display to values to panel*/
    
			SetCtrlVal (panel, PANEL_TEXTBOX, Data);
			SetCtrlVal (panel, PANEL_TEXTBOX_4, Leng);    
			SetCtrlVal (panel, PANEL_TEXTBOX_5, Stat); 

			break;
		}
	return 0;
}

int CVICALLBACK DOS (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	switch (event)
		{
		case EVENT_COMMIT:
		
			GetCtrlVal (panel,PANEL_NUMERIC, &val);   
		
			initialize (21,0);      		  	/* make PC a controller at address 21 */
   			send (val,"*IDN?",&status);     	/* device command to set mode */
   			enter (Data,80,&l,val,&status);    	/* read data */
    		printf ("Data received=%s\n",Data); /* send data to DOS console*/
	

			break;
		}
	return 0;
}

int CVICALLBACK Clear (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	switch (event)
		{
		case EVENT_COMMIT:
		
			/*clears text boxes*/	
			
			ResetTextBox (panel, PANEL_TEXTBOX,"");
			ResetTextBox (panel, PANEL_TEXTBOX_4,"");    
			ResetTextBox (panel, PANEL_TEXTBOX_5,""); 
			        
			break;
		}
	return 0;
}

int CVICALLBACK About (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	switch (event)
		{
		case EVENT_COMMIT:
		
			MessagePopup ("About KPCI-488 Test Panel CVI","Keithley KPCI-488 CVI Demo Version 1.0 \n\n Copyright 2002, Keithley \n\n E-mail: ustechsupport@keithley.com, Web: www.keithley.com");

			break;
		}
	return 0;
}

int CVICALLBACK Exit (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	switch (event)
		{
		case EVENT_COMMIT:
		
			QuitUserInterface(0);   /*close window*/   

			break;
		}
	return 0;
}
